<?php
session_start();
$keywords = "contact us, email us";
$description = "Contact Evolution Windows and Doors.";
$title = "Contact Us | Evolution Windows and Doors";
require 'php/setVariables.php';
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <?php
  require 'req/header.php';
  ?>
    <link href="css/contact_css.css?v=<?= $style_version?>" rel="stylesheet" type="text/css">
</head>

<body>

  <!-- content begin -->


  <!-- navigation menu -->


  <?php require 'req/top.php'; ?>


  <main>



    <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="comTitle">
            <h1><?php echo $company; ?></h1>
          </div>
        </div>
      </div>
    </section>



    <section>
      <div class="pageFull contbg">
        <div class="contWrap">
          <div class="contRight">

              <div class="contForm pt-0" id="newsf">
                  <form class="contactForm-second" id="contactForm" action="php/contact_form.php" method="post">

                        <?php if( !empty($_GET['success']) ){ ?>
                        <div class="success-label">
                            <span class="icon">&#10003;</span>
                            Email sent successfully!
                        </div>
                        <?php } ?>

                        <?php if( !empty($_GET['error']) ){ ?>
                            <div class="success-label error" >
                              <span class="icon">&#9888;</span>
                              <?= $_GET['error']?>
                            </div>
                        <?php } ?>

                        <input type="text" name="honeypot" style="display: none;">
                        <input type="hidden" name="form" value="contactForm">
                        <div class="">
                          <label class="font-bold" for="first-name">First Name:</label>
                          <input type="text" id="first-name" name="first-name" required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="last-name">Last Name:</label>
                          <input type="text" id="last-name" name="last-name" required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="address">Street Address:</label>
                          <!-- For Google Maps Address Autocomplete, you'd need to integrate the Google Places API -->
                          <input type="text" id="address" name="address" required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="city">City:</label>
                          <input type="text" id="city" name="city" required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="zip">Zip:</label>
                          <input type="text" id="zip" name="zip" pattern="\d{5}" title="Please enter a 5-digit zip code." placeholder="Please enter a 5-digit zip code." required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="email">Email:</label>
                          <input type="text" id="email" name="email" required>
                        </div>

                        <div class="">
                          <label class="font-bold" for="cell-phone">Cell Phone:</label>
                          <input type="tel" id="cell-phone" name="cell-phone" required>
                        </div>

                        <div class="">
                          <label class="font-bold">Are You the Homeowner?</label>

                          <div class="radio">
                            <input id="radio-1" name="homeowner" type="radio" value="Yes">
                            <label  for="radio-1" class="radio-label">Yes</label>
                          </div>

                          <div class="radio">
                            <input id="radio-2" name="homeowner" type="radio" value="Yes">
                            <label  for="radio-2" class="radio-label">No</label>
                          </div>

                        </div>

                        <hr>
                        <label class="font-bold">Tell Us About Your Needs</label>

                        <div class="">
                          <label class="font-bold">Check ALL That Apply:</label>

                          <div class="check-box-wrap">
                            <input class="my-checkbox" type="checkbox" id="pool-cage" name="repair-needs[]" value="I Need Windows Installed">
                            <span for="pool-cage">I Need Windows Installed</span>
                          </div>

                          <div class="check-box-wrap">
                            <input class="my-checkbox" type="checkbox" id="lanai-screens" name="repair-needs[]" value="I Need Doors Installed">
                            <span for="lanai-screens">I Need Doors Installed</span>
                          </div>
                        </div>

                        <div class="">
                          <label class="font-bold">How Many Panels Do You Need Replaced:</label>
                          <select name="panels-replaced" required>
                              <option value="0">0</option>
                              <option value="less-than-5">Less Than 5</option>
                              <option value="more-than-5">More Than 5</option>
                          </select>
                        </div>

                        <div class="">
                          <label class="font-bold" for="additional-details">Would you like to add any details about your needs?</label>
                          <textarea id="additional-details" name="additional-details"></textarea>
                        </div>

                        <div class="contactFormFull">
                           <input type="submit" name="submit" value="Submit">
                        </div>
                     </form>
              </div>


          </div>

        </div>
      </div>
    </section>





  </main>

  <?php require 'req/footer.php'; ?>
  <!-- content end -->



</body>

</html>
