<!DOCTYPE html>
<html lang="en">
<head>
<?php
    require 'php/setVariables.php';
    $keywords = "frequently asked questions, faq";
    $description = "Get quick answers on our FAQ page. Simplifying queries about Evolution Windows and Doors. Your key to informed decisions.";
    $title = "Frequently Asked Questions | Evolution Windows and Doors";

    require 'req/header.php';
?>
</head>

<body>

  <!-- content begin -->


 <!-- navigation menu -->


   <?php require 'req/top.php'; ?>


  <main>



      <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="comTitle">
            <h1>Frequently Asked Questions</h1>
          </div>
        </div>
      </div>
    </section>



      <section>
        <div class="pageFull faqbg">
            <div class="faqWrap">

                <div class="faqBox">
                            <h3>1. What types of windows and doors are suitable for my home?</h3>

                            <p>The choice depends on your preferences, but popular options include double-hung windows for versatility and durability and fiberglass doors for a combination of strength and energy efficiency.</p>
                </div>

                <div class="faqBox">
                            <h3>2. How do I choose the right size for windows and doors?</h3>
                            <p> Measure the width and height of the existing openings accurately. We can guide you through the process to ensure a proper fit.</p>
                </div>

                <div class="faqBox">
                            <h3>3. What materials are commonly used, and how do they differ?</h3>
                            <p>Common materials include wood, vinyl, aluminum, and composite. Wood offers a classic look, vinyl is low-maintenance, aluminum is durable, and composites provide a blend of qualities.</p>
                </div>

                 <div class="faqBox">
                            <h3>4. Are there energy-efficient options available?</h3>
                            <p>Absolutely. Consider windows with double-pane glass and low-E coatings. For doors, look for insulated options to enhance energy efficiency and reduce utility costs.</p>
                </div>

                 <div class="faqBox">
                            <h3>5. What security features should I consider?</h3>
                            <p>Look for multi-point locking systems on doors and impact-resistant glass for windows to enhance your home's security.</p>
                </div>

                <div class="faqBox">
                            <h3>6. Do I need permits for installation?</h3>
                            <p>It depends on local regulations. We can assist you in understanding and obtaining any necessary permits for your project.</p>
                </div>

                 <div class="faqBox">
                            <h3>7. How do maintenance and upkeep differ for various materials?</h3>
                            <p>Maintenance varies. Vinyl is low-maintenance, wood may require more attention, and aluminum is resistant to rust. We'll provide care guidelines based on your selection.</p>
                </div>

                  <div class="faqBox">
                            <h3>8. Can I customize the design of my windows and doors?</h3>
                            <p>Certainly! You can choose from various colors, finishes, and hardware options to match your style and preferences.</p>
                </div>

                <div class="faqBox">
                            <h3>9. What is the installation process like, and how long does it take?</h3>
                            <p>Installation timelines vary, but we strive to complete projects efficiently. We'll provide a detailed overview of the process during our consultation.</p>
                </div>
                <div class="faqBox">
                            <h3>10. What warranties are offered?</h3>
                            <p>Warranties cover different aspects, including materials and workmanship. We'll provide you with comprehensive warranty information for your selected windows and doors.</p>
                </div>

            </div>
          </div>
      </section>





  </main>

  <?php require 'req/footer.php'; ?>
  <!-- content end -->



</body>

</html>
