<!DOCTYPE html>
<html lang="en">

<head>
  <?php
  require 'php/setVariables.php';
  $keywords = "windows, windows frames";
  $description = "Elevate your space with Evolution Windows and Doors. Discover style, durability, and energy efficiency in every frame. Redefine your view today.";
  $title = "Windows | Evolution Windows and Doors";

  require 'req/header.php';
  ?>
  <!-- owl carousal -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
  <!-- end owl carousal -->
</head>

<body>

  <!-- content begin -->


  <!-- navigation menu -->


  <?php require 'req/top.php'; ?>


  <main>

    <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="comTitle">
            <h1>residential window replacement</h1>
          </div>
        </div>
      </div>
    </section>

    <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="windowsSliderWrap">
            <div class="windSlidList owl-carousel owl-theme">

              <div class="windSlidItem">
                <img src="images/windows/double-hung.png" alt="Double-hung">
                <p class="titleBellow">Double-hung</p>
              </div>
              <div class="windSlidItem">
                <img src="images/windows/two-part-slider.jpg" alt="Two-part Slider">
                <p class="titleBellow">Two-part Slider</p>
              </div>
              <div class="windSlidItem">
                <img src="images/windows/three-part-slider.jpg" alt="Three-part Slider">
                <p class="titleBellow">Three-part Slider</p>
              </div>

              <div class="windSlidItem">
                <img src="images/windows/combination-window.jpg" alt="Combination Window">
                <p class="titleBellow">Combination Window</p>
              </div>
            </div>

            <p class="swipearrows"><span><img src="images/icons/arrow-left-green.png" alt="Arrow Left"></span> swipe side to side <span><img src="images/icons/arrow-right.png" alt="Arrow Right"></span></p>

          </div>
        </div>
      </div>
    </section>



    <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="secWrap">

            <div class="floorWrap">

              <div class="floorList">
                <h3>residential window features</h3>
                <div class="installpar">
                  <p>Homeowners are often surprised to find that our Georgetown series includes features commonly seen among higher-end home windows, but for a cost-effective price. Georgetown windows include:</p>
                </div>

                <ul>
                  <li>¾-inch sealed insulated glass</li>
                  <li>Cam-type lock and keeper for a weather-tight seal</li>
                  <li>Deluxe limit lock for added security</li>
                  <li>DuraTex™ warm-edge spacer system for decreased heat transfer</li>
                  <li>Integral lift rail and tilt-latch for ease of use</li>
                  <li>Large glass surfaces for maximum light and ventilation</li>
                  <li>Multi-chambered, hollow thermalized insulating system</li>
                  <li>Secure integral interlock for enhanced protection and weatherproofing</li>
                  <li>Sloped sill for easy water run-off</li>
                  <li>Weatherstripping for reduced air infiltration</li>
                  <li>Welded sash and frame corners for added strength and durability</li>
                </ul>
                <div class="installpar">
                  <p></p>
                </div>
                <div class="installpar">
                  <p>Thanks in part to these features, Georgetown windows have achieved a remarkable R45 performance grade (three times higher than the R15 threshold grade for residential windows).</p>
                </div>

              </div>


              <div class="floorList">
                <h3>Window Anatomy</h3>
                <ul>
                  <li>Welded sash and frame corners mean durability and dependability.</li>
                  <li>State-of-the-art operating mechanism allows years of easy window operation.</li>
                  <li>Deluxe limit lock provides added security while using the window for ventilation.</li>
                  <li>Integral tilt-latch makes the window easy to tilt in plus leaves smooth window apperance.</li>
                  <li>Cam-type lock and keeper pulls and keeps your window sashes tightly together for a complete weather-tight seal.</li>
                  <li>Integral lift rail makes your window easy to open and close.</li>
                  <li>Special formula PVC never needs painting, makes cleaning a snap, and prevents scratching or denting.</li>
                  <li>Multi-chambered, hollow thermalized insulating system provides more dead air space for better insulation and adds greater strength and durability to the window.</li>
                  <li>Integral weatherstripping decreases air infiltration plus will never peel off.</li>
                  <li>Integral interlock keeps windows closed tight for added security and weatherproofing.</li>
                  <li>Full 3/4″ sealed insulated glass protects your home from heat and col all year long.</li>
                  <li>DuraTex™ warm edge technology glass spacer systems reduces heat transfer and provides improved seal integrity.</li>
                  <li>Sloped sill permits easy water run-off.</li>
                </ul>
              </div>
            </div>

          </div>
        </div>
      </div>
    </section>






    <section>
      <div class="pageFull">
        <div class="pageSize">
          <div class="windowsSliderWrap">
            <div class="windSlidList owl-carousel owl-theme">

              <div class="windSlidItem">
                <img src="images/windows-new/double-hung.jpg" alt="Double Hung">
              </div>
              <div class="windSlidItem">
                <img src="images/windows-new/potomac-corner2.jpg" alt="Potomac Corner 2">
              </div>
              <div class="windSlidItem">
                <img src="images/windows-new/stack1b.jpg" alt="Stack 1b">
              </div>

              <div class="windSlidItem">
                <img src="images/windows-new/mechanism-close.jpg" alt="Mechanism Close">
              </div>


              <div class="windSlidItem">
                <img src="images/windows-new/photo-of-potomac-cherry.jpg" alt="Potomac Cherry">
              </div>

              <div class="windSlidItem">
                <img src="images/windows-new/incision-windows-closer-1.jpg" alt="Incision Window Closer">
              </div>

              <div class="windSlidItem">
                <img src="images/windows-new/incision-windows-closer-2.jpg" alt="Incision Window Closer">
              </div>

              <div class="windSlidItem">
                <img src="images/windows-new/incision-windows-closer-3.jpg" alt="Incision Window Closer">
              </div>
            </div>

            <p class="swipearrows"><span><img src="images/icons/arrow-left-green.png" alt="Arrow Left"></span> swipe side to side <span><img src="images/icons/arrow-right.png" alt="Arrow Right"></span></p>

          </div>
        </div>
      </div>
    </section>







<section>
  <div class="pageFull">
    <div class="pageSize">
      <div class="secWrap">

        <div class="floorWrap">

          <div class="floorList">
            <h3>Glass</h3>
            <div class="installpar">
              <p>We use Cardinal Glass which is the same glass used by large manufacturers such as Andersen, Pella and Marvin.</p>
            </div>

            <h3>Strength</h3>
            <div class="installpar">
              <p>Reinforced meeting rail (image with green composite material inside vinyl).</p>
            </div>
            <ul>
              <li>All our windows have reinforced meeting rails</li>
              <li>Allows locks and keepers to be anchored into the sash where other vinyl window locks and keepers are screwed into the vinyl only</li>
            </ul>


            <div class="installpar addMarg">
              <p>Interlocks at meeting rail</p>
            </div>
            <ul>
              <li>Reduces air infiltration, adds security, creates a tighter, better performing window overall</li>
              <li>All 3 series of our windows have interlocks where many manufacturers offer on select models or don't offer at all</li>
            </ul>


            <div class="installpar addMarg">
              <p>Bottom Sash interlock leg</p>
            </div>
            <ul>
              <li>Secondary interlock in the bottom sill of the window that allows the bottom sash to have a more secure fit</li>
              <li>It helps reduce air and insect infiltration and increases security</li>
            </ul>


            <div class="installpar addMarg">
              <p>Double Walled Mortised Sill Dam</p>
            </div>
            <ul>
              <li>Sill dam wall that helps prevent moisture or insects from coming in or what I'd call as last line of defense</li>
              <li>The sill dam wall is integrated into the frame so there are no weak points or no gaps for air or insects to come through</li>
            </ul>


          </div>


          <div class="floorList">
            <h3>Design Consistency</h3>
            <ul>
              <li>From top line to bottom line, our core strength designs (listed above) stay consistent.</li>
              <li>We don't skimp on design but rather, keep it consistent so the homeowner is getting a premium product no matter which line they choose of ours.</li>
            </ul>

            <h3 class="addMarg">Air Infiltration</h3>
            <div class="installpar">
              <p>We have some of the lowest air infiltration ratings in the industry</p>
            </div>
            <ul>
              <li>Potomac - 0.02 CFM</li>
              <li>Fortis - 0.04 CFM</li>
              <li>Georgetown - 0.05 CFM</li>
            </ul>

            <div class="installpar addMarg">
              <p>For reference, most high performance windows are around 0.15 CFM (Cubic Feet per Minute)</p>
            </div>
            <ul>
              <li>0.30 CFM - industry standard that NFRC tests</li>
              <li>0.23 CFM - traditional wood double hung windows</li>
              <li>0.15 CFM - most high performance windows</li>
            </ul>

            <h3 class="addMarg">Lifetime Warranty</h3>
            <ul>
              <li>We offer a full lifetime warranty through our dealers.</li>
              <li>Don't make homeowners jump through hoops to renew or charge a fee for transferring.</li>
            </ul>


          </div>
        </div>

      </div>
    </div>
  </div>
</section>



  </main>

  <?php require 'req/footer.php'; ?>
  <!-- content end -->

  <!-- owl carousal -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <script>
    $('.owl-carousel').owlCarousel({
      loop: true,
      margin: 40,
      nav: false,
      responsive: {
        0: {
          stagePadding: 0,
          loop: true,
          responsiveClass: true,
          dots: true,
          autoHeight: true,
          nav: false,
          items: 1,
        },
        479: {
          items: 1,
        },
        768: {
          items: 2,
        },
        1024: {
          items: 3,
        },
        1920: {
          items: 3,
        },

        2560: {
          items: 4,
        },
      }
    })
  </script>
  <!-- end owl carousal -->


</body>

</html>
